﻿#include "precompiled.h"
#include "common.h"
#include "Film.h"

#include "Texture1D.h"

const int kInitialFilmSpeed = 100;
const int kMinFilmSpeed = 25;	// Minimum film sensitivity
const int kMaxFilmSpeed = 3200; // Maximum film sensitivity

namespace RTCam {

Film::Film(void) :
	m_filmSpeed(kInitialFilmSpeed),
	m_responseCurveTex(nullptr)
{
}


Film::~Film(void)
{
}


int Film::ValidateFilmSpeed( int filmSpeed )
{
	return Clamp(filmSpeed, kMinFilmSpeed, kMaxFilmSpeed);
}

int Film::GetFilmSpeed()
{
	return m_filmSpeed;
}

void Film::SetFilmSpeed( int filmSpeed )
{
	m_filmSpeed = ValidateFilmSpeed(filmSpeed);
}

} // end namespace